//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

UiDropDownBase {
    id : uiDropDown

    function getLabel(obj) {
        if (typeof obj === "string")
            return obj;

        var props = [ "label", "name", "text" ];

        for (var i = 0; i < props.length; ++i) {
            if (props[i] in obj) {
                return obj[props[i]];
            }
        }

        return obj.toString();
    }

    delegate : Item {
        implicitHeight : 24
        implicitWidth  : Math.max(uiDropDown.width, label.implicitWidth + 12)

        width : parent ? parent.width : implicitWidth

        Text {
            id : label

            text  : getLabel(modelData)
            font  : UiFonts.getFont(UiFonts.Light, 14)
            color : UiColors.getColor(UiColors.Black)
            anchors.fill : parent
            verticalAlignment : Qt.AlignVCenter
            leftPadding : 6
            rightPadding : 6
            elide : Text.ElideRight
            wrapMode : Text.NoWrap
        }
    }

    highlightDelegate : Rectangle {
        color  : UiColors.getColor(UiColors.HoverGreen)
        x      : 1
        width  : uiDropDown.width - 2
        height : parent.height
    }

    labelDelegate :  UiText {
        text  : {
            if (!uiDropDown.currentElement)
                return "";

            return getLabel(uiDropDown.currentElement);
        }
        x     : uiDropDown.leftMargin
        y     : uiDropDown.topMargin
    }
}
